#include "ganah engine.h"
#include <stdlib.h>
#include <stdio.h>

GanahEngine *GanahEngine::m_pGanahEngine = NULL;
ModeJeu GanahEngine::m_ModeJeu = SOLO;

int main(int argc,char *argv[])
{
    int iCptFrequence=0;
    bool bAffiche = false;

    if ( argc == 2 )
    {
        if ( strcmp(argv[1],"multi") == 0 )
                GanahEngine::setModeJeu(MULTI);
    }

    if ( initialiserJeu() )
    {
        if ( !GanahEngine::getEngine()->initialiser() )
        {
                allegro_message("Initialisation du GanahEngine Impossible");
                return 0;                
        }

        debutJeu();
        iCptFrequence=GanahEngine::getEngine()->getTimer();
        while ( !GanahEngine::getEngine()->getQuitter() )
        {
                g_SGTimer.tester();
                if ( !GanahEngine::getEngine()->getPause() )
                {

                        if ( GanahEngine::getEngine()->getTimer()-iCptFrequence >= 
                                                GanahEngine::getEngine()->getFrequence())
                        {
                                GanahEngine::getEngine()->m_iCptEffectif+=GanahEngine::getEngine()->getFrequence();
                                iCptFrequence=GanahEngine::getEngine()->getTimer();
                                g_SGPhysique.calculer();
                                g_SGPhysique.traiterCollisions();
                                g_SGPhysique.majCoordonnees();
                                g_SGAffichage.animerSprites();
                                if ( GanahEngine::getEngine()->getModeJeu() == MULTI )
                                     g_SGReseau.updateReseau();
                                g_SGEvent.testEvents();
                                if ( GanahEngine::getEngine()->getModeJeu() == MULTI )
                                {
                                     if (! bAffiche)
                                          afficherJeu();
                                     bAffiche = false;   
                                }
                        }
                        else
                        {
                                afficherJeu();
                                if ( GanahEngine::getEngine()->getModeJeu() == MULTI )
                                {                                
                                     bAffiche = true;
                                }
                        }
                }
        }
    }
    finJeu();
    detruireJeu();
    return 0;
}

END_OF_MAIN();

GanahEngine::GanahEngine(char *szTitre,const short int iLargeur,const short int iHauteur,
                const char cCouleur,const int iFrequence,ModeAffichage mode,TypeAffichage type)
{
    m_iCptEffectif= 0;
    printf("Dans le constructeur de GanahEngine\n");
    m_pGanahEngine=this;
    m_pSGAffichage=new SGAffichage(iLargeur,iHauteur,cCouleur,mode,type);
    m_pSGFichier=new SGFichier;
    m_pSGEvent=new SGEvent;
    m_pSGEntite=new SGEntite;
    m_pSGReseau=new SGReseau;
    m_pSGTimer=new SGTimer(&m_iCptEffectif);
    m_iFrequence=1000/iFrequence;
    m_pSGPhysique=new SGPhysique(iFrequence,5000);
    m_bPause=false;
    m_bQuitter=false;
    m_szTitre=szTitre;
}

bool GanahEngine::initialiser()
{
    if ( allegro_init() != 0 )
        return false;
    set_window_title(m_szTitre);
    if ( install_keyboard() != 0 )
        return false;
    if ( install_timer() != 0 )
        return false;

    set_window_close_button(0);
        
    LOCK_VARIABLE(m_pGanahEngine->m_viTimer);
    LOCK_FUNCTION(GanahEngine::runTimer);
    install_int_ex(GanahEngine::runTimer,BPS_TO_TIMER(1000));
    
    g_SGAffichage.initialiser();
    
    return true;
}

GanahEngine::~GanahEngine()
{
    delete m_pSGAffichage;
    delete m_pSGFichier;
    delete m_pSGEvent;
    if ( GanahEngine::getEngine()->getModeJeu() == MULTI )
        delete m_pSGReseau;
    delete m_pSGEntite;
    delete m_pSGTimer;
}

void GanahEngine::runTimer()
{
    m_pGanahEngine->m_viTimer++;
}
END_OF_FUNCTION(GanahEngine::runTimer);


